﻿package  
{
	import flash.display.Loader;
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.events.MouseEvent;
	import flash.events.TimerEvent;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	//import com.greensock.TweenLite;
	//import com.greensock.easing.*;
	import caurina.transitions.Tweener;
	import flash.utils.Timer;
	/**
	 * Main class for slide show
	 * @author Maxim
	 */
	public class SlideShow extends MovieClip 
	{
		
		private var nextThumbButton:MovieClip;
		private var prevThumbButton:MovieClip;
		private var thumbsMask:MovieClip;
		private var currentThumb:Thumb;
		private var slideContainer:SlideContainer; //container of current slide
		private var thumbsContainer:Sprite; //container for thumbs
		private var captionsContainer:Captions; //container for captions
		private var captionsMask:Sprite; //mask for captions 
		private var xml:XML; //slide show xml
		private var slideIndex:int = -1; //index of current displayed slide
		private var thumbsArray:Array;
		private var _captionsEnabled:Boolean = true;
		private var slideShowTimer:Timer; //slideshow time
		
		
		private static const XML_URL:String = "slideshow.xml"; //path to xml file
		private static const THUMB_CONTAINER_POSITION:Point = new Point(0, 450); //initial position of thumbs container
		private static const THUMB_WIDTH:Number = 110; // standart thumb width
		private static const SLIDE_SHOW_INTERVAL:Number = 4000; //slide show time interval in miliseconds
		
		public function SlideShow() 
		{
			super();
			
			if (!stage) {
				addEventListener(Event.ADDED_TO_STAGE, init);
			}else {
				init();
			}
		}
		
		
		
		private function init(e:Event=null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			//1.Prepare buttons
			nextThumbButton = thumbsNextBtn;
			nextThumbButton.mouseChildren = false;
			nextThumbButton.gotoAndStop("disabled");
		//	nextThumbButton.buttonMode = true;
			
			
			prevThumbButton = thumbsPrevBtn;
			prevThumbButton.mouseChildren = false;
			prevThumbButton.gotoAndStop("disabled");
		//	prevThumbButton.buttonMode = true;
			
			addChild(prevThumbButton);
			addChild(nextThumbButton);
			
			//2.prepare thumb container
			thumbsContainer = new Sprite();
			thumbsContainer.x = THUMB_CONTAINER_POSITION.x;
			thumbsContainer.y = THUMB_CONTAINER_POSITION.y;
			addChild(thumbsContainer);
			
			//4.slide container
			slideContainer = new SlideContainer(this);
			addChild(slideContainer);

			//5. captions container and its mask
			captionsContainer = info_mc;
			captionsContainer.addEventListener(Event.RESIZE, captionsResized);
			addChild(captionsContainer);
			
			captionsMask = new Sprite();
			captionsMask.graphics.beginFill(0, 0);
			captionsMask.graphics.drawRect(0, 0, 800, 450);
			addChild(captionsMask);
			captionsContainer.mask = captionsMask;
			
			var loadStroke = new stroke();
			addChild(loadStroke);
			loadStroke.y=449;
			
			//3. thumb mask
			thumbsMask = new ThumbsMask();
			thumbsMask.x = THUMB_CONTAINER_POSITION.x;
			thumbsMask.y = THUMB_CONTAINER_POSITION.y;
			thumbsContainer.mask = thumbsMask;
			addChild(thumbsMask);
			
			//5. Load XML
			loadXML();
		}
		
		private function enableThumbsListeners():void 
		{
			trace("Enable thumb listeners");
			//1. enable thumb nav buttons in the bottom
			setThumbsNavButtons();
			
			//2. enable nav buttons in the slide container
			slideContainer.enableMouseListeners();
			//3. enable click listeners for all thumbs
			for each (var item:Thumb in thumbsArray) 
			{
				item.addEventListener(MouseEvent.CLICK, thumbClick);
			}
		}
		
		/**
		 * Sets states for thumbs nav buttons
		 */
		private function setThumbsNavButtons():void 
		{
			if (thumbsContainer.width > thumbsMask.width) {
				var thumbsRect:Rectangle = thumbsContainer.getRect(this);
				if (thumbsRect.x < thumbsMask.x) {
					prevThumbButton.gotoAndStop("enabled");
					prevThumbButton.buttonMode = true;
					prevThumbButton.addEventListener(MouseEvent.CLICK, prevThumbClick);
				}else {
					prevThumbButton.gotoAndStop("disabled");
				}
				
				
				if ((thumbsRect.x + thumbsRect.width) > (thumbsMask.x + thumbsMask.width)) {
					nextThumbButton.gotoAndStop("enabled");
					nextThumbButton.buttonMode = true;
					nextThumbButton.addEventListener(MouseEvent.CLICK, nextThumbClick);
				}else {
					nextThumbButton.gotoAndStop("disabled");
				}
			}else {
				//disable bottom thumb nav buttons
				prevThumbButton.gotoAndStop("disabled");
				nextThumbButton.gotoAndStop("disabled");
			}
			
			
		}
		
		private function disableThumbsListeners():void 
		{
			//1. disable thumb nav buttons in the bottom
			nextThumbButton.buttonMode = false;
			nextThumbButton.removeEventListener(MouseEvent.CLICK, nextThumbClick);
			prevThumbButton.buttonMode = false;
			prevThumbButton.removeEventListener(MouseEvent.CLICK, prevThumbClick);
			//2. disable nav buttons in the slide container
			slideContainer.disableMouseListeners();
			//3. disable click listeners for all thumbs
			for each (var item:Thumb in thumbsArray) 
			{
				item.removeEventListener(MouseEvent.CLICK, thumbClick);
			}
		}
		
		private function prevThumbClick(e:MouseEvent):void 
		{
			if (thumbsContainer.width > thumbsMask.width) {
				var gotoX:Number = thumbsContainer.x + THUMB_WIDTH * 7;
				var maxX:Number = THUMB_CONTAINER_POSITION.x;
				if (gotoX > maxX) {
					gotoX = maxX;
				}
				//TweenLite.to(thumbsContainer, .7, { x:gotoX, ease:Linear.easeNone, onComplete:enableThumbsListeners } );
				Tweener.addTween(thumbsContainer, { time:0.7, x:gotoX, onComplete: enableThumbsListeners } );
				disableThumbsListeners();
			}
		}
		
		private function nextThumbClick(e:MouseEvent):void 
		{
			if (thumbsContainer.width > thumbsMask.width) {
				var gotoX:Number = thumbsContainer.x - THUMB_WIDTH*7;
				var minX:Number = thumbsMask.width - thumbsContainer.width - (Math.ceil(thumbsContainer.width/thumbsMask.width)*thumbsMask.width - thumbsContainer.width );
				if (gotoX < minX) {
					gotoX = minX;
				}
				//TweenLite.to(thumbsContainer, .7, { x:gotoX, ease:Linear.easeNone, onComplete:enableThumbsListeners } );
				Tweener.addTween(thumbsContainer, { time:0.7, x:gotoX, onComplete: enableThumbsListeners } );
				disableThumbsListeners();
			}
		}
		

		
		
		private function loadXML():void 
		{
			var request:URLRequest = new URLRequest(XML_URL);
			var loader:URLLoader = new URLLoader(request);
			loader.addEventListener(Event.COMPLETE, xmlLoaded);
			loader.addEventListener(IOErrorEvent.IO_ERROR, onIOError);
		}

		private function xmlLoaded(e:Event):void 
		{
			trace("xml loaded!");
			xml = XML(e.target.data);
			//draw thumbs
			drawThumbs();
			//show 1st slide
			showSlide(0);
			
			//setThumbsNavButtons();
		}
		
		private function drawThumbs():void 
		{
			thumbsArray = new Array();
			var initX:Number = 0;
			
			for each (var item:XML in xml.slide) 
			{
				var thumb:Thumb = new Thumb();
				thumb.mouseChildren = false;
				thumb.buttonMode = true;
				
				var thumbBackground:MovieClip;
				var thumbLoader:Loader = new Loader();
					
				if (item.childIndex() % 2 == 0) { //if 4etnii
					thumbBackground = new LightGreyBg();
				}else {
					thumbBackground = new DarkGreyBg();
				}
				thumbLoader.load(new URLRequest(item.thumbImage));
				thumb.addChild(thumbBackground);
				thumb.addChild(thumbLoader);
				
				thumb.x = initX;

				thumb.addEventListener(MouseEvent.ROLL_OVER, thumbsRollOver);
				thumb.addEventListener(MouseEvent.ROLL_OUT, thumbsRollOut);
				thumb.addEventListener(MouseEvent.CLICK, thumbClick);
				thumbsArray.push(thumb);//push thumb into thumbs array
				thumbsContainer.addChild(thumb);

				initX += 110;
			}
			
			thumbsContainer.cacheAsBitmap = true;
			
			//enable thumbs nav
			enableThumbsListeners();
		}
		
		private function thumbClick(evt:MouseEvent):void 
		{
			showSlide(thumbsArray.indexOf(evt.target));
		}
		
		private function showSlide(newIndex:int):void 
		{
			//deselect all slides
			if (newIndex != slideIndex) {
				
				deselectAllSlides();
				
				slideIndex = newIndex;
				
				currentThumb = Thumb(thumbsArray[slideIndex]);
				currentThumb.selectSlide();
				slideContainer.showSlide(String(xml.slide[slideIndex].fullSizeImage));
				
				captionsContainer.setText(String(xml.slide[slideIndex].description));
				
				
				var currentThumbRect:Rectangle = currentThumb.getRect(this); //find position of current thumb relative this
				if (currentThumbRect.x < thumbsMask.x || currentThumbRect.x >= thumbsMask.x + thumbsMask.width) { //if thumb is outside of view port
					var semerka:Number = Math.ceil((slideIndex + 1) / 7);
					var firstThumbInSequence:Thumb = Thumb(thumbsArray[semerka * 7 - 7]);
					disableThumbsListeners();
				//	TweenLite.to(thumbsContainer, .7, { x: - firstThumbInSequence.x, onComplete:enableThumbsListeners } );	
					Tweener.addTween(thumbsContainer, { time:0.7, x: - firstThumbInSequence.x, onComplete: enableThumbsListeners } );
				}
	
			}
		}
		/**
		 * Deselect all slides
		 */
		private function deselectAllSlides():void 
		{
			for each (var item:MovieClip in thumbsArray) 
			{
				Thumb(item).deselectSlide();
			}
		}
		

		
		private function thumbsRollOver(evt:MouseEvent):void 
		{
			var thumb:Thumb = Thumb(evt.target);
			if (thumb != currentThumb) {
				thumb.selectSlide();
			}
		}
		
		private function thumbsRollOut(evt:MouseEvent):void 
		{
			var thumb:Thumb = Thumb(evt.target);
			if (thumb != currentThumb) {
				thumb.deselectSlide();
			}
			
		}
		
		private function onIOError(e:IOErrorEvent):void 
		{
			trace(e.text);
		}
	
		public function showNextSlide():void 
		{
			
			var newIndex:int = slideIndex + 1;
			if (newIndex >= xml.slide.length()) {
				newIndex = 0;
			}
			
			showSlide(newIndex);
		}
		
		public function showPrevSlide():void 
		{
			
			var newIndex:int = slideIndex - 1;
			if (newIndex < 0) {
				newIndex = xml.slide.length() - 1;
			}
			
			showSlide(newIndex);	
		}
		/**
		 * When caption resized - recalculate its position
		 * @param	evt
		 */
		private function captionsResized(evt:Event):void 
		{
			if(_captionsEnabled){ //recalculate captions position only when captions are enabled
				captionsContainer.y = THUMB_CONTAINER_POSITION.y - captionsContainer.height;
			}
		}
		/**
		 * Getter for _captionsEnabled property
		 */
		public function get captionsEnabled():Boolean 
		{
			return _captionsEnabled;
		}
		/**
		 * Setter for _captionsEnabled property
		 */
		public function set captionsEnabled(value:Boolean):void 
		{
			_captionsEnabled = value;
		//	TweenLite.killTweensOf(captionsContainer);
			
			if (_captionsEnabled) {
			//	TweenLite.to(captionsContainer, 0.3, { y:THUMB_CONTAINER_POSITION.y - captionsContainer.height } );
				Tweener.addTween(captionsContainer, { time:0.3, y:THUMB_CONTAINER_POSITION.y - captionsContainer.height } );
			}else {
			//	TweenLite.to(captionsContainer, 0.3, { y:THUMB_CONTAINER_POSITION.y } );
				Tweener.addTween(captionsContainer, { time:0.3, y:THUMB_CONTAINER_POSITION.y } );
			}
		}
		
		
		public function startSlideShow():void 
		{
			trace("start slide show!");
			if (!slideShowTimer) {
				slideShowTimer = new Timer(SLIDE_SHOW_INTERVAL, 0);
				slideShowTimer.addEventListener(TimerEvent.TIMER, onSlideShowTimer);
			}
			slideShowTimer.reset();
			slideShowTimer.start();
		}
		
		public function stopSlideShow():void 
		{
			trace("stop slide show!");
			slideShowTimer.stop();
		}
		
		/**
		 * When slideshow time tick - show next slide
		 * @param	evt
		 */
		private function onSlideShowTimer(evt:TimerEvent):void 
		{
			showNextSlide();
		}
	}

}