package  
{
	import flash.display.Bitmap;
	import flash.display.Loader;
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.events.MouseEvent;
	import flash.net.URLRequest;
	//import com.greensock.TweenLite;
	import caurina.transitions.Tweener;
	/**
	 * ...
	 * @author Maxim
	 */
	public class SlideContainer extends Sprite 
	{
		private var image:Bitmap;
		private var slideShow:SlideShow;
		private var nextButton:MovieClip;
		private var prevButton:MovieClip;
		private var playPauseButton:MovieClip;
		private var infoButton:MovieClip;
		private var imageLoader:Loader;
		
		public function SlideContainer(slideShow:SlideShow) 
		{
			super();
			
			this.slideShow = slideShow;
			
			if (!stage) {
				addEventListener(Event.ADDED_TO_STAGE, init)
			}else {
				init();
			}
		}
		
		private function init(e:Event=null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			nextButton = new NextSlideButton();
			nextButton.mouseChildren = false;
			nextButton.buttonMode = true;
			nextButton.x = 760;
			nextButton.y = 192;
			nextButton.addEventListener(MouseEvent.CLICK, nextButtonClick);
			addChild(nextButton);
			
			prevButton = new NextSlideButton();
			prevButton.mouseChildren = false;
			prevButton.buttonMode = true;
			prevButton.x = 40;
			prevButton.y = 192;
			prevButton.scaleX = -1;
			prevButton.addEventListener(MouseEvent.CLICK, prevButtonClick);
			addChild(prevButton);
			
			playPauseButton = new PlayPauseButton();
			playPauseButton.x = 738; 
			playPauseButton.y = 0;
			playPauseButton.width = 30;
			playPauseButton.height = 30;
			playPauseButton.mouseChildren = false;
			playPauseButton.buttonMode = true;
			playPauseButton.addEventListener(MouseEvent.CLICK, playPauseButtonClick);
			addChild(playPauseButton);
			
			infoButton = new InfoButton();
			infoButton.x = 770;
			infoButton.y = 0;
			infoButton.width = 30;
			infoButton.height = 30;
			infoButton.mouseChildren = false;
			infoButton.buttonMode = true;
			infoButton.addEventListener(MouseEvent.CLICK, infoButtonClick);
			addChild(infoButton);
			
			
			
			addEventListener(MouseEvent.ROLL_OVER, onRollOver);
			addEventListener(MouseEvent.ROLL_OUT, onRollOut);
		}
		/**
		 * When click on play pause button - change button state and call SlideShow.startSlideShow() or stopSlideShow()
		 */
		private function playPauseButtonClick(evt:MouseEvent):void 
		{
			if (playPauseButton.currentFrameLabel == "pause") {
				playPauseButton.gotoAndStop("play");
				slideShow.startSlideShow();
			}else {
				playPauseButton.gotoAndStop("pause");
				slideShow.stopSlideShow();
			}
		}
		
		/**
		 * Enable/disable captions
		 * @param	evt
		 */
		private function infoButtonClick(evt:MouseEvent):void 
		{
			slideShow.captionsEnabled = !slideShow.captionsEnabled;
		}
		
		
		private function prevButtonClick(e:MouseEvent):void 
		{
			slideShow.showPrevSlide();
		}
		
		private function nextButtonClick(e:MouseEvent):void 
		{
			slideShow.showNextSlide();
		}
		
		private function onRollOut(e:MouseEvent):void 
		{
			//TweenLite.to(nextButton, 0.25, { alpha:0 } );
			Tweener.addTween(nextButton, { time: 0.25, alpha:0 } );
			
			//TweenLite.to(prevButton, 0.25, { alpha:0 } );
			Tweener.addTween(prevButton, { time:0.25, alpha:0 } );
			
			//TweenLite.to(playPauseButton, 0.25, { alpha:0 } );
			Tweener.addTween(playPauseButton, { time:0.25, alpha:0 } );
			
			//TweenLite.to(infoButton, 0.25, { alpha:0 } );
			Tweener.addTween(infoButton, { time:0.25, alpha:0 } );
		}
		
		private function onRollOver(e:MouseEvent):void 
		{
			//TweenLite.to(nextButton, 0.25, { alpha:1 } );
			Tweener.addTween(nextButton, { time: 0.25, alpha:1 } );
			
			//TweenLite.to(prevButton, 0.25, { alpha:1 } );
			Tweener.addTween(prevButton, { time:0.25, alpha:1 } );
			
			//TweenLite.to(playPauseButton, 0.25, { alpha:1 } );
			Tweener.addTween(playPauseButton, { time:0.25, alpha:1 } );
			
			//TweenLite.to(infoButton, 0.25, { alpha:1 } );
			Tweener.addTween(infoButton, { time:0.25, alpha:1 } );
			
		}
		
		public function showSlide(url:String):void 
		{
			if (imageLoader) { //remove all listeners from previous loader if it is 
				
				
				
				try{ //close all loading operations
					imageLoader.close();
				}catch (e:Error) {
					trace("Warning: slide loader does not have active load() operations.")
				}
				
				imageLoader.contentLoaderInfo.removeEventListener(Event.COMPLETE, imageLoaded);
				imageLoader.contentLoaderInfo.removeEventListener(IOErrorEvent.IO_ERROR, onIOError);
			}
			
			imageLoader = new Loader(); //image loader
			imageLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, imageLoaded, false, 0, true);
			imageLoader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, onIOError, false, 0, true);
			imageLoader.load(new URLRequest(url));
		}
		
		private function onIOError(e:IOErrorEvent):void 
		{
			trace(e.text);
		}
		
		
		private function imageLoaded(e:Event):void 
		{
			if (image) {
				//TweenLite.to(image, 0.15, { alpha:0 } );
				Tweener.addTween(image, { time:0.2, alpha:0 } );
			}
			image = Bitmap(e.target.content);
			image.alpha = 0;
			addChildAt(image,0);
			//TweenLite.to(image, 0.15, { alpha:1 } );
			Tweener.addTween(image, { time:0.2, alpha:1 } );
		}
		
		public function disableMouseListeners():void 
		{
			infoButton.removeEventListener(MouseEvent.CLICK, infoButtonClick);
			nextButton.removeEventListener(MouseEvent.CLICK, nextButtonClick);
			prevButton.removeEventListener(MouseEvent.CLICK, prevButtonClick);
			playPauseButton.removeEventListener(MouseEvent.CLICK, playPauseButtonClick);
		}
		
		public function enableMouseListeners():void 
		{
			infoButton.addEventListener(MouseEvent.CLICK, infoButtonClick);
			nextButton.addEventListener(MouseEvent.CLICK, nextButtonClick);
			prevButton.addEventListener(MouseEvent.CLICK, prevButtonClick);
			playPauseButton.addEventListener(MouseEvent.CLICK, playPauseButtonClick);
		}
	}

}